// Copyright (c) Caliper Corporation 2003.  All Rights Reserved
// Written by Kjartan Stefansson - Caliper Corporation - February 2003

    // This toolbox generates a great circle line annotation 
    // between two points on a map.
    
    // The macro illustrates how to:
    // 1. Get a two-point line from the user.
    // 2. Create an array of values.
    // 3. Use coordinate geometry to create a new coordinate based on a distance and
    //    direction from an existing coordinate.
    // 4. Create an annotation.

    // You can modify the toolbox to let the user set the number of points, etc.

    // To run this toolbox using the GISDK toolbox:
    // 1. Open or choose the layer that you want to use.
    // 2. Choose Tools-Add-Ins and open the GIS Developer's Kit toolbox.
    // 3. Compile this toolbox in test mode using the first button (Compile).
    // 4. Run this toolbox by clicking the second button (Test), typing the dbox 
    //    name "Great Circle Line", clicking the Dialog box radio button, and clicking OK.

dbox "Great Circle Line" toolbox nokeyboard

    // Tool for creating great circle line annotation
    tool "Gc" 0,0 
        icons: "bmp\\buttons.bmp|233", "bmp\\buttons.bmp|267"
        help: "Click Endpoints of a Great Circle"
    do
        // Make sure user is clicking on a map window
        if GetWindowType() = "Map" then do
            // Quit if user hits escape while clicking
            on escape goto gcline_done
            // Get beginning and ending points of line
            c = ClickLine()
            // Use 100 shape points
            nPoints = 100
            dim pts[nPoints]
            // Get the total distance and angle between the two points
            dist = GetDistance(c[1], c[2])
            angle = Azimuth(c[1], c[2])
            // Set first and last points to clicked coordinates
            pts[1] = c[1]
            pts[nPoints] = c[2]
            // Compute intermediate points at even spacing along the great circle
            for i = 2 to nPoints-1 do
                pts[i] = MoveAlongGreatCircle(c[1], angle, dist * i / nPoints)
                end
            // Add a polyline annotation with these points
            AddAnnotation(, "PolyLine", {{"Line Color", ColorRGB(0,0,0)},
                                         {"Points", pts}})
          gcline_done:
        end
    endItem

    // Close toolbox when the Close button is clicked
    close do
        Return()
    endItem

enddbox
